/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.wrapper;

public class Coordinate {
    private final double x;
    private final double y;
    private final double z;

    public Coordinate(double x2, double y, double z2) {
        this.x = x2;
        this.y = y;
        this.z = z2;
    }

    public Coordinate(int x2, int y, int z2) {
        this.x = x2;
        this.y = y;
        this.z = z2;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        int x2 = (int)this.getX();
        return this.getX() < (double)x2 ? x2 - 1 : x2;
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return (int)this.getY();
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        int z2 = (int)this.getZ();
        return this.getZ() < (double)z2 ? z2 - 1 : z2;
    }

    public double getDistanceBetweenCoordinates(Coordinate compare) {
        double diffX = this.getX() - compare.getX();
        double diffY = this.getY() - compare.getY();
        double diffZ = this.getZ() - compare.getZ();
        return Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Coordinate) {
            Coordinate compare = (Coordinate)obj;
            return compare.getX() == this.getX() && compare.getY() == this.getY() && compare.getZ() == this.getZ();
        }
        return false;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

