/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.GuiMain;
import com.sijobe.installer.ManifestHandler;
import com.sijobe.installer.ThreadBackupMCJAR;
import com.sijobe.installer.ThreadBackupWorlds;
import com.sijobe.installer.ThreadInstall;
import com.sijobe.installer.Util;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class ActionHandler {
    public List files;
    public ManifestHandler manifest;
    public static File base;
    private static GuiMain gui;
    static /* synthetic */ Class class$0;

    public ActionHandler(GuiMain gui) {
        this.initialiseData();
        ActionHandler.gui = gui;
    }

    public boolean initialiseData() {
        this.files = Util.getFilesExceptCurrent();
        File f = Util.getFile("manifest.xml", this.files);
        if (f == null) {
            return false;
        }
        this.manifest = new ManifestHandler(f);
        return true;
    }

    public void backupMCJAR(File dir) {
        base = dir;
        ThreadBackupMCJAR mcj = new ThreadBackupMCJAR(dir);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mcj.setCallback(clazz.getDeclaredMethod("callbackBackupMCJAR", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mcj.start();
    }

    public static void callbackBackupMCJAR(String err) {
        if (err != null) {
            gui.sendError(err);
            System.out.println("ERROR MCJAR: " + err);
        } else {
            gui.sendSuccessMessage("Minecraft.jar was successfully backed up");
            System.out.println("Minecraft.jar was successfully backed up to " + base + "/backup");
        }
    }

    public void backupWorlds(File dir) {
        ThreadBackupWorlds mcw = new ThreadBackupWorlds(dir);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mcw.setCallback(clazz.getDeclaredMethod("callbackBackupWorlds", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mcw.start();
    }

    public static void callbackBackupWorlds(String err) {
        if (err != null) {
            gui.sendError(err);
            System.out.println("ERROR MCWORLD: " + err);
        } else {
            gui.sendSuccessMessage("Worlds were successfully backed up");
            System.out.println("Worlds were successfully backed up to " + base + "/backup/saves");
        }
    }

    public void install(String project, List installFiles, File installBase, File destination, ManifestHandler manifest, boolean backupJAR, boolean backupWorld) {
        base = installBase;
        if (backupJAR) {
            System.out.println("Backing up your Minecraft.jar...");
            ActionHandler.callbackBackupMCJAR(ThreadBackupMCJAR.backupMinecraftJar(destination));
        }
        if (backupWorld) {
            System.out.println("Backing up your Minecraft worlds...");
            ActionHandler.callbackBackupWorlds(ThreadBackupWorlds.backupWorlds(destination));
        }
        System.out.println("Beginning installation...");
        ActionHandler.callbackInstall(ThreadInstall.install(project, installFiles, installBase, destination, manifest));
    }

    public static void callbackInstall(String err) {
        if (err != null) {
            gui.sendError("Installation failed, see advanced for more information");
            System.out.println("ERROR - INSTALLATION FAILED: " + err);
        } else {
            gui.sendSuccessMessage("Installation was successful");
            System.out.println("Installation was successful");
        }
        gui.installMod(false);
    }

    public void startMinecraft(File dir) {
        try {
            Vector<String> params = new Vector<String>();
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-classpath");
                params.add("Minecraft.jar;lwjgl.jar;lwjgl_util.jar;jinput.jar");
                params.add("-Djava.library.path=\"natives\"");
                params.add("net.minecraft.client.Minecraft");
            } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-Xincgc");
                params.add("-classpath");
                params.add("Minecraft.jar:lwjgl.jar:lwjgl_util.jar:jinput.jar");
                params.add("-Dorg.lwjgl.librarypath=\"./natives\"");
                params.add("-Dnet.java.games.input.librarypath=\"$./natives\"");
                params.add("net.minecraft.client.Minecraft");
            } else {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-Xincgc");
                params.add("-classpath");
                params.add("Minecraft.jar:lwjgl.jar:lwjgl_util.jar:jinput.jar");
                params.add("-Dorg.lwjgl.librarypath=\"./natives\"");
                params.add("-Dnet.java.games.input.librarypath=\"./natives\"");
                params.add("net.minecraft.client.Minecraft");
            }
            if (params.size() > 0) {
                ProcessBuilder pb = new ProcessBuilder(params);
                pb.directory(new File(dir, "bin"));
                Process process = pb.start();
                if (process == null) {
                    throw new Exception("Process is null");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

