/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.Util;
import java.io.File;
import java.lang.reflect.Method;

public class ThreadBackupMCJAR
extends Thread {
    private File mcdir;
    private Method callback;

    public ThreadBackupMCJAR(File mcdir) {
        this.mcdir = mcdir;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String backupMinecraftJar(File mcdir) {
        if (mcdir == null || !mcdir.exists()) {
            return "Couldn't discover Minecraft home directory.";
        }
        File mcjar = new File(mcdir, "bin/minecraft.jar");
        if (!mcjar.exists()) {
            return "Couldn't find Minecraft.jar";
        }
        File destination = new File(mcdir, "backup/bin");
        try {
            destination.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!destination.exists()) {
            return "Couldn't create destination directory for backup.";
        }
        if (!Util.copyFile(mcjar, new File(destination, "Minecraft.jar." + System.currentTimeMillis()))) {
            return "Failed to make a copy of Minecraft.jar";
        }
        return null;
    }

    public void run() {
        this.signalDone(ThreadBackupMCJAR.backupMinecraftJar(this.mcdir));
    }
}

