/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.World;
import java.util.List;

@Command(name="difficulty", description="Sets the difficulty of the game. Valid values 0-3", example="0", videoURL="http://www.youtube.com/watch?v=jkXYM8S41uY", version="1.0", alias={"diff"})
public class Difficulty
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterInteger("[DIFFICULTY]", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        World world = StandardCommand.getSenderAsPlayer(sender).getWorld();
        if (params.size() > 0) {
            world.setDifficulty((Integer)params.get(0));
        } else {
            world.setDifficulty((world.getDifficulty() + 1) % 4);
        }
        String difficulty = "";
        switch (world.getDifficulty()) {
            case 0: {
                difficulty = (Object)((Object)FontColour.GREEN) + "peaceful";
                break;
            }
            case 1: {
                difficulty = (Object)((Object)FontColour.YELLOW) + "easy";
                break;
            }
            case 2: {
                difficulty = (Object)((Object)FontColour.ORANGE) + "normal";
                break;
            }
            case 3: {
                difficulty = (Object)((Object)FontColour.RED) + "hard";
            }
        }
        sender.sendMessageToPlayer("Difficulty was set to " + difficulty);
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

