/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Item;
import java.util.List;

@Command(name="enchant", description="Enchants the currently selected item", example="add protection 10", videoURL="http://www.youtube.com/watch?v=zd9mPAU5TG8", version="1.0")
public class Enchant
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<list|remove|add <TYPE> [LEVEL]>", false, new String[]{"list", "add", "remove"}), new ParameterString("", true), new ParameterInteger("", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        String argument = (String)params.get(0);
        if (argument.equalsIgnoreCase("list")) {
            String list = "";
            for (String i : Item.getEnchantments()) {
                if (i == null) continue;
                list = list + i + " (" + this.getEnchantmentId(i) + "), ";
            }
            list = list.substring(0, list.length() - 2);
            sender.sendMessageToPlayer((Object)((Object)FontColour.GREEN) + "Enchantments [name (id)]:");
            sender.sendMessageToPlayer(list);
        } else if (argument.equalsIgnoreCase("add")) {
            if (params.size() == 1) {
                throw new CommandException(this.getUsage(sender));
            }
            int id = -1;
            try {
                id = Integer.parseInt((String)params.get(1));
            }
            catch (Exception e) {
                id = this.getEnchantmentId((String)params.get(1));
            }
            if (id < 0) {
                throw new CommandException("Invalid enchantment specified.");
            }
            int level = 1;
            if (params.size() == 3) {
                level = (Integer)params.get(2);
            }
            String name = null;
            name = Item.addEnchantmentToCurrentItem(Enchant.getSenderAsPlayer(sender), id, level);
            if (name == null) {
                throw new CommandException("Unable to add the specified enchantment with ID " + id);
            }
            Enchant.getSenderAsPlayer(sender).sendChatMessage("The " + (Object)((Object)FontColour.AQUA) + name + (Object)((Object)FontColour.WHITE) + " command was successfully added.");
        } else {
            Item.removeEnchantmentsOnCurrentItem(Enchant.getSenderAsPlayer(sender));
            Enchant.getSenderAsPlayer(sender).sendChatMessage("Enchantment(s) for the current item were removed");
        }
    }

    public int getEnchantmentId(String enchantment) {
        return Item.getEnchantments().indexOf(enchantment);
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

