/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterDouble;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="explode", description="Sets off an explosion in your current location.", example="10", videoURL="http://www.youtube.com/watch?v=rWOpPWYjjxY")
public class Explode
extends StandardCommand {
    public static final int DEFAULT_SIZE = 4;
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterInteger("[SIZE]", true), new ParameterDouble("[X Y Z]", true), new ParameterDouble("", true), new ParameterDouble("", true)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player = Explode.getSenderAsPlayer(sender);
        if (params.size() == 0) {
            player.getWorld().createExplosion(player, player.getPosition(), 4);
        } else if (params.size() == 1) {
            player.getWorld().createExplosion(player, player.getPosition(), (Integer)params.get(0));
        } else if (params.size() > 3) {
            Coordinate location = new Coordinate((Double)params.get(1), (Double)params.get(2), (Double)params.get(3));
            player.getWorld().createExplosion(player, location, (Integer)params.get(0));
        }
        sender.sendMessageToPlayer("Boom!");
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

