/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Player;
import com.sijobe.spc.wrapper.World;
import java.util.List;

@Command(name="hardcore", description="Configures the world to be in hardcore mode or not", example="enable", videoURL="http://www.youtube.com/watch?v=1_woyXQ3io4", version="1.0")
public class Hardcore
extends StandardCommand {
    @Override
    public void execute(CommandSender sender, List params) {
        Player player = StandardCommand.getSenderAsPlayer(sender);
        World world = player.getWorld();
        if (params.size() > 0) {
            world.setHardcore((Boolean)params.get(0));
        } else {
            world.setHardcore(!world.isHardcore());
        }
        player.sendChatMessage("Hardcore mode was " + (Object)((Object)FontColour.AQUA) + (world.isHardcore() ? "enabled" : "disabled"));
    }

    @Override
    public Parameters getParameters() {
        return Parameters.DEFAULT_BOOLEAN;
    }
}

