/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="moveplayer", description="move the player to the distance and direction specified", example="10 north", videoURL="http://www.youtube.com/watch?v=4omil8aeRRY", version="1.4.5")
public class MovePlayer
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterInteger("[DISTINCT]", false), new ParameterString("[DIRECTION(N/E/S/W/U/D)]", false)});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player = StandardCommand.getSenderAsPlayer(sender);
        Coordinate c = player.getPosition();
        int distance = 0;
        try {
            distance = Integer.parseInt((String)params.get(0));
        }
        catch (NumberFormatException e) {
            throw new CommandException("Could not parse disance specified as integer: " + params.get(0));
        }
        if (((String)params.get(1)).toUpperCase().startsWith("N")) {
            player.setPosition(new Coordinate(player.getPosition().getX(), player.getPosition().getY(), player.getPosition().getZ() - (double)distance));
        } else if (((String)params.get(1)).toUpperCase().startsWith("E")) {
            player.setPosition(new Coordinate(player.getPosition().getX() + (double)distance, player.getPosition().getY(), player.getPosition().getZ()));
        } else if (((String)params.get(1)).toUpperCase().startsWith("S")) {
            player.setPosition(new Coordinate(player.getPosition().getX(), player.getPosition().getY(), player.getPosition().getZ() + (double)distance));
        } else if (((String)params.get(1)).toUpperCase().startsWith("W")) {
            player.setPosition(new Coordinate(player.getPosition().getX() - (double)distance, player.getPosition().getY(), player.getPosition().getZ()));
        } else if (((String)params.get(1)).toUpperCase().startsWith("U")) {
            player.setPosition(new Coordinate(player.getPosition().getX(), player.getPosition().getY() + (double)distance, player.getPosition().getZ()));
        } else if (((String)params.get(1)).toUpperCase().startsWith("D")) {
            player.setPosition(new Coordinate(player.getPosition().getX(), player.getPosition().getY() - (double)distance, player.getPosition().getZ() - (double)distance));
        } else {
            throw new CommandException("Invalid direction specified.");
        }
        sender.sendMessageToPlayer("Moved from " + (Object)((Object)FontColour.AQUA) + c.getBlockX() + (Object)((Object)FontColour.WHITE) + ", " + (Object)((Object)FontColour.AQUA) + c.getBlockX() + (Object)((Object)FontColour.WHITE) + ", " + (Object)((Object)FontColour.AQUA) + c.getBlockX() + (Object)((Object)FontColour.WHITE) + " to " + (Object)((Object)FontColour.AQUA) + player.getPosition().getBlockX() + (Object)((Object)FontColour.WHITE) + ", " + (Object)((Object)FontColour.AQUA) + player.getPosition().getBlockY() + (Object)((Object)FontColour.WHITE) + ", " + (Object)((Object)FontColour.AQUA) + player.getPosition().getBlockZ());
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

