/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.core.IPlayerMP;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterInteger;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Item;
import com.sijobe.spc.wrapper.Player;
import java.util.HashMap;
import java.util.List;

@Command(name="path", description="Creates a path", version="1.4")
public class Path
extends StandardCommand
implements IPlayerMP {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("[BLOCK]", true), new ParameterInteger("[RADIUS]", true)});
    private static HashMap playerConfig = new HashMap();

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Player player = Path.getSenderAsPlayer(sender);
        String playerName = player.getPlayerName();
        if (params.size() >= 1) {
            String[] args = ((String)params.get(0)).split("(\\^|:)");
            int block = -1;
            int size = 3;
            try {
                block = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                block = -1;
            }
            if (block == -1) {
                block = Item.getItemId(args[0].replace('_', ' '));
            }
            if (args[0].equalsIgnoreCase("air")) {
                block = 0;
            }
            if (!player.getWorld().isValidBlockType(block) && block != 0) {
                throw new CommandException("Unknown block: " + args[0]);
            }
            if (params.size() > 1) {
                size = (Integer)params.get(1);
                if (size < 1) {
                    throw new CommandException("Size must be at least 1.");
                }
                if (size > 50) {
                    sender.sendMessageToPlayer("Clamping path size.");
                    size = 50;
                }
            }
            sender.sendMessageToPlayer("Path mode enabled.");
            playerConfig.put(playerName, new int[]{block, size, -1, -1, -1});
        } else if (playerConfig.containsKey(playerName) && ((int[])playerConfig.get(playerName))[0] > -1) {
            sender.sendMessageToPlayer("Path mode disabled.");
            ((int[])Path.playerConfig.get((Object)playerName))[0] = -1;
        } else {
            throw new CommandException("Must specify block.");
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }

    @Override
    public void init(Object ... params) {
    }

    @Override
    public void onTick(Player player) {
        String playerName = player.getPlayerName();
        if (!playerConfig.containsKey(playerName)) {
            return;
        }
        int[] plrData = (int[])playerConfig.get(playerName);
        this.makePath(player, plrData);
    }

    private void makePath(Player player, int[] data) {
        if (data[0] >= 0) {
            Coordinate position = player.getPosition();
            int x2 = kx.c((double)position.getX());
            int y = kx.c((double)position.getY());
            int z = kx.c((double)position.getZ());
            if (x2 != data[2] || y != data[3] || z != data[4]) {
                int start;
                for (int i = start = data[1] * -1 + 1; i < data[1]; ++i) {
                    for (int j = -1; j < data[1]; ++j) {
                        for (int k = start; k < data[1]; ++k) {
                            if (j == -1) {
                                this.setBlock(player, x2 + i, y + j, z + k, data[0]);
                                continue;
                            }
                            this.setBlock(player, x2 + i, y + j, z + k, 0);
                        }
                    }
                }
                data[2] = x2;
                data[3] = y;
                data[4] = z;
            }
        }
    }

    private void setBlock(Player player, int i, int j, int k, int type) {
        player.getWorld().setBlock(new Coordinate(i, j, k), type);
    }
}

