/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.core.IPlayerSP;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.util.Settings;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Minecraft;
import com.sijobe.spc.wrapper.Player;
import java.util.List;

@Command(name="setspeed", description="Sets the players speed to the value specified", example="2", videoURL="http://www.youtube.com/watch?v=G48upLnQr-s", version="1.3", enabled=true)
public class SetSpeed
extends StandardCommand
implements IPlayerSP {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<SPEED|reset>", false)});
    private static final double DEFAULT_SPEED = 1.0;
    private static final String CONFIG_KEY = "speed";

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        Settings config = StandardCommand.loadSettings(StandardCommand.getSenderAsPlayer(sender));
        if (((String)params.get(0)).equalsIgnoreCase("reset")) {
            config.set(CONFIG_KEY, 1.0);
        } else {
            try {
                config.set(CONFIG_KEY, Double.parseDouble((String)params.get(0)));
            }
            catch (Exception e) {
                throw new CommandException("Could not parse " + (String)params.get(0) + " as a speed.");
            }
        }
        config.save();
        sender.sendMessageToPlayer("Player speed set to " + (Object)((Object)FontColour.AQUA) + config.getDouble(CONFIG_KEY, 1.0) + (Object)((Object)FontColour.WHITE) + "x normal speed");
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }

    @Override
    public void init(Object ... params) {
    }

    @Override
    public void onTick(Player player) {
    }

    @Override
    public boolean isEnabled() {
        return Minecraft.isSinglePlayer();
    }

    @Override
    public void movePlayer(Player player, float forward, float strafe, float speed) {
        Double pspeed = StandardCommand.loadSettings(player).getDouble(CONFIG_KEY, 1.0);
        if (pspeed == null || pspeed == 1.0) {
            return;
        }
        Double d = pspeed;
        Double d2 = pspeed = Double.valueOf(pspeed - 1.0);
        double direction = Math.sqrt(forward * forward + strafe * strafe);
        if (direction < (double)0.01f) {
            return;
        }
        if (direction < 1.0) {
            direction = 1.0;
        }
        direction = (double)speed / direction;
        forward = (float)((double)forward * direction);
        strafe = (float)((double)strafe * direction);
        double f4 = Math.sin((double)player.getYaw() * Math.PI / 180.0);
        double f5 = Math.cos((double)player.getYaw() * Math.PI / 180.0);
        Coordinate motion = player.getMotion();
        double motionx = (double)forward * f5 - (double)strafe * f4;
        double motionz = (double)strafe * f5 + (double)forward * f4;
        player.setMotion(new Coordinate(motion.getX() + motionx * pspeed, motion.getY(), motion.getZ() + motionz * pspeed));
    }
}

