/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.command;

import com.sijobe.spc.command.Command;
import com.sijobe.spc.command.StandardCommand;
import com.sijobe.spc.util.FontColour;
import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ParameterBoolean;
import com.sijobe.spc.validation.ParameterString;
import com.sijobe.spc.validation.Parameters;
import com.sijobe.spc.wrapper.CommandException;
import com.sijobe.spc.wrapper.CommandSender;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Player;
import com.sijobe.spc.wrapper.World;
import java.util.List;

@Command(name="weather", description="Commands to toggle weather effects on/off", example="lightning", videoURL="http://www.youtube.com/watch?v=mgGOtzmD31k", version="1.0")
public class Weather
extends StandardCommand {
    private static final Parameters PARAMETERS = new Parameters(new Parameter[]{new ParameterString("<lightning|[thunder|rain [enable|disable]]>", false, new String[]{"lightning", "thunder", "rain"}), new ParameterBoolean("", true, "enable", "disable")});

    @Override
    public void execute(CommandSender sender, List params) throws CommandException {
        String argument = (String)params.get(0);
        Player player = StandardCommand.getSenderAsPlayer(sender);
        World world = player.getWorld();
        if (argument.equalsIgnoreCase("rain")) {
            boolean rain;
            boolean bl = rain = !world.isRaining();
            if (params.size() > 1) {
                rain = (Boolean)params.get(1);
            }
            world.setRaining(rain);
            sender.sendMessageToPlayer("Rain was " + (Object)((Object)FontColour.AQUA) + (rain ? "enabled" : "disabled"));
        } else if (argument.equalsIgnoreCase("thunder")) {
            boolean thunder;
            boolean bl = thunder = !world.isThunder();
            if (params.size() > 1) {
                thunder = (Boolean)params.get(1);
            }
            world.setThunder(thunder);
            world.setRaining(thunder);
            sender.sendMessageToPlayer("Thunder was " + (Object)((Object)FontColour.AQUA) + (thunder ? "enabled" : "disabled"));
        } else if (argument.equalsIgnoreCase("lightning")) {
            Coordinate coordinate = player.trace(128.0);
            if (coordinate == null) {
                return;
            }
            world.useLightning(coordinate);
        } else {
            sender.sendMessageToPlayer("The " + argument + " command is currently unavailable.");
        }
    }

    @Override
    public Parameters getParameters() {
        return PARAMETERS;
    }
}

