/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.core;

import com.sijobe.spc.core.IHook;
import com.sijobe.spc.core.SPCLoader;
import com.sijobe.spc.util.DynamicClassLoader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HookManager {
    private List master = new ArrayList();
    private Map typemap = new HashMap();

    public HookManager() {
        this.master = new ArrayList();
        this.typemap = new HashMap();
    }

    public void register(Class hook) {
        if (Modifier.isAbstract(hook.getModifiers())) {
            return;
        }
        try {
            this.register((IHook)hook.newInstance());
        }
        catch (Exception e) {
            System.err.println("Could not load hook " + hook.getName() + ". " + "Check that the class has the default constructor visible.");
            e.printStackTrace();
        }
    }

    public void register(IHook hook) {
        if (this.master.contains(hook)) {
            return;
        }
        this.master.add(hook);
    }

    public void remove(IHook hook) {
        if (this.master.contains(hook)) {
            this.master.remove(hook);
        }
        for (Class types : this.typemap.keySet()) {
            ((List)this.typemap.get(types)).remove(hook);
        }
    }

    public void remove(Class type) {
        for (IHook hook : this.master) {
            if (!type.isAssignableFrom(hook.getClass())) continue;
            this.master.remove(hook);
        }
        for (Class types : this.typemap.keySet()) {
            for (IHook hook : (List)this.typemap.get(types)) {
                if (!type.isAssignableFrom(hook.getClass())) continue;
                ((List)this.typemap.get(types)).remove(hook);
            }
            if (((List)this.typemap.get(types)).size() != 0) continue;
            this.typemap.remove(this.typemap.get(types));
        }
    }

    public List getHooks(Class type) {
        if (this.typemap.containsKey(type)) {
            return (List)this.typemap.get(type);
        }
        ArrayList<IHook> thisType = new ArrayList<IHook>();
        for (IHook hook : this.master) {
            if (!type.isAssignableFrom(hook.getClass())) continue;
            thisType.add(hook);
        }
        this.typemap.put(type, thisType);
        return thisType;
    }

    public void loadHooks(Class type) {
        SPCLoader.load();
        List hooks = DynamicClassLoader.getClasses(type);
        if (hooks != null) {
            for (Class hook : hooks) {
                this.register(hook);
            }
        }
    }
}

