/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.updater;

import com.sijobe.spc.updater.ModVersion;
import com.sijobe.spc.updater.UpdateCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CheckVersion
extends Thread {
    public static final String MANIFEST = "http://bit.ly/spccheckupdate";
    private UpdateCallback callback;
    private List projects;
    private String mcversion;

    public CheckVersion(ModVersion[] project, String mcver, UpdateCallback callback) {
        this.callback = callback;
        this.projects = Arrays.asList(project);
        this.mcversion = mcver;
    }

    @Override
    public void run() {
        File f = this.downloadFile(MANIFEST);
        if (f == null || !f.exists()) {
            return;
        }
        Vector update = this.parseManifest(f);
        Vector<HashMap> required = new Vector<HashMap>();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (HashMap h : update) {
            boolean checkversion = true;
            String version = (String)h.get("version");
            if (version == null) {
                checkversion = false;
            }
            boolean checkdate = true;
            String datetime = (String)h.get("datetime");
            if (datetime == null) {
                checkdate = false;
            }
            for (ModVersion svi : this.projects) {
                boolean add = false;
                if (checkversion && svi.getVersion() != null && version.compareTo(svi.getVersion()) > 0) {
                    add = true;
                }
                if (!add && checkdate && svi.getLastUpdate() != null) {
                    long updatemanifest = 0L;
                    try {
                        Date updateman = dateformat.parse(datetime);
                        updatemanifest = updateman.getTime();
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                    if (updatemanifest > svi.getLastUpdate().getTime()) {
                        add = true;
                    }
                }
                if (!add) continue;
                if (this.mcversion == null || this.mcversion.equalsIgnoreCase("")) {
                    required.add(h);
                    continue;
                }
                for (String pver : (List)h.get("minecraft")) {
                    if (!pver.equalsIgnoreCase(this.mcversion)) continue;
                    required.add(h);
                }
            }
        }
        try {
            f.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.callback != null) {
            try {
                this.callback.updateCallback(required);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector parseManifest(File manifest) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Vector<HashMap> ps = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(manifest);
            Element e = d.getDocumentElement();
            if (e.getAttribute("version").compareTo("1.0") > 0) {
                System.out.println("Warning: checking for the update may fail. New version of manifest file detected");
            }
            NodeList nl = e.getElementsByTagName("project");
            ps = new Vector<HashMap>();
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el2 = (Element)nl.item(i);
                    for (ModVersion spc : this.projects) {
                        if (spc.getName() == null || !el2.getAttribute("name").equalsIgnoreCase(spc.getName())) continue;
                        HashMap h = this.getProject(el2);
                        h.put("name", spc.getName());
                        ps.add(h);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ps;
    }

    private HashMap getProject(Element project) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("version", this.getValue(project, "version"));
        h.put("datetime", this.getValue(project, "datetime"));
        h.put("website", this.getValue(project, "website"));
        h.put("download", this.getValue(project, "download"));
        h.put("message", this.getValue(project, "message"));
        NodeList minecraft = project.getElementsByTagName("minecraft");
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < minecraft.getLength(); ++i) {
            v.add(this.getValue((Element)minecraft.item(i), "supportedversion"));
        }
        h.put("minecraft", v);
        return h;
    }

    private String getValue(Element e, String tag) {
        String s = null;
        NodeList n = e.getElementsByTagName(tag);
        if (n != null && n.getLength() > 0) {
            s = ((Element)n.item(0)).getTextContent();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFile(String rawurl) {
        File temp = null;
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            URL url = new URL(rawurl);
            url.openConnection();
            is = url.openStream();
            temp = File.createTempFile("spcupdate", System.currentTimeMillis() + "");
            fos = new FileOutputStream(temp);
            byte[] buffer = new byte[1024];
            int bytes = 0;
            while ((bytes = is.read(buffer)) > 0) {
                fos.write(buffer, 0, bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                temp.delete();
            }
            catch (Exception e2) {
                // empty catch block
            }
            temp = null;
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception e) {}
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return temp;
    }
}

