/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.util;

import com.sijobe.spc.util.KeyListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lwjgl.input.Keyboard;

public class KeyboardHandler
extends Thread {
    public static final long DELAY = 10L;
    private static KeyboardHandler KEYBOARD = new KeyboardHandler();
    private boolean listening = false;
    private List keys;
    private List pressed;
    private Map registeredPressed = new ConcurrentHashMap();
    private Map registeredReleased = new ConcurrentHashMap();

    public static KeyboardHandler getInstance() {
        return KEYBOARD;
    }

    private KeyboardHandler() {
        this.pressed = new CopyOnWriteArrayList();
        this.keys = new CopyOnWriteArrayList();
    }

    @Override
    public void run() {
        try {
            while (this.listening) {
                if (!Keyboard.isCreated()) {
                    this.listening = false;
                    break;
                }
                for (Integer press : this.pressed) {
                    if (Keyboard.isKeyDown((int)press)) continue;
                    this.keyReleased(press);
                }
                for (Integer key : this.keys) {
                    if (!Keyboard.isKeyDown((int)key) || this.pressed.contains(key)) continue;
                    this.keyPressed(key);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {}
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.listening = false;
        }
    }

    private void keyPressed(int key) {
        this.pressed.add(key);
        if (this.registeredPressed.get(key) == null) {
            return;
        }
        for (KeyListener listener : (List)this.registeredPressed.get(key)) {
            listener.keyPressed(key);
        }
    }

    private void keyReleased(int key) {
        this.pressed.remove((Object)key);
        if (this.registeredReleased.get(key) == null) {
            return;
        }
        for (KeyListener listener : (List)this.registeredReleased.get(key)) {
            listener.keyReleased(key);
        }
    }

    public void stopListening() {
        this.listening = false;
    }

    public boolean addKeyPressedListener(int key, KeyListener listener) {
        return this.addListener(key, listener, this.registeredPressed);
    }

    public boolean addKeyReleasedListener(int key, KeyListener listener) {
        return this.addListener(key, listener, this.registeredReleased);
    }

    private boolean addListener(int key, KeyListener listener, Map internal) {
        if (Keyboard.getKeyName((int)key) == null) {
            return false;
        }
        CopyOnWriteArrayList<KeyListener> keylist = (CopyOnWriteArrayList<KeyListener>)internal.get(key);
        if (keylist == null) {
            keylist = new CopyOnWriteArrayList<KeyListener>();
            internal.put(key, keylist);
        }
        keylist.add(listener);
        if (this.keys.indexOf(key) == -1) {
            this.keys.add(key);
        }
        if (!this.listening) {
            this.listening = true;
            this.start();
        }
        return true;
    }

    public void removeKeyPressedListener(int key, KeyListener listener) {
        this.removeListener(key, listener, this.registeredPressed);
    }

    public void removeKeyReleasedListener(int key, KeyListener listener) {
        this.removeListener(key, listener, this.registeredReleased);
    }

    private void removeListener(int key, KeyListener listener, Map internal) {
        if (!this.keys.contains(key)) {
            return;
        }
        List list = (List)internal.get(key);
        if (list != null) {
            list.remove(listener);
        }
        this.checkKeyUsage(key);
    }

    private void checkKeyUsage(int key) {
        List pressed = (List)this.registeredPressed.get(key);
        boolean pressedEmpty = false;
        if (pressed != null && pressed.size() == 0) {
            this.registeredPressed.remove(key);
            pressedEmpty = true;
        }
        List released = (List)this.registeredReleased.get(key);
        boolean releasedEmpty = false;
        if (released != null && released.size() == 0) {
            this.registeredReleased.remove(key);
            releasedEmpty = true;
        }
        if (pressedEmpty && releasedEmpty) {
            this.keys.remove((Object)key);
            pressed.remove((Object)key);
        }
    }

    public static int getKeyCode(String key) {
        if (key == null) {
            return -1;
        }
        return Keyboard.getKeyIndex((String)key.toUpperCase()) == 0 ? -1 : Keyboard.getKeyIndex((String)key.toUpperCase());
    }
}

