/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.util;

import java.lang.reflect.Field;

public class ReflectionHelper {
    public static boolean getBoolean(Field field, Object instance) {
        if (field == null) {
            System.err.println("Null field");
            return false;
        }
        try {
            return field.getBoolean(instance);
        }
        catch (Exception e) {
            System.err.println(field.getType() + " not assignable from " + Boolean.TYPE);
            return false;
        }
    }

    public static double getDouble(Field field, Object instance) {
        if (field == null) {
            System.err.println("Null field");
            return -1.0;
        }
        try {
            return field.getDouble(instance);
        }
        catch (Exception e) {
            System.err.println(field.getType() + " not assignable from " + Double.TYPE);
            return -1.0;
        }
    }

    public static int getInt(Field field, Object instance) {
        if (field == null) {
            System.err.println("Null field");
            return -1;
        }
        try {
            return field.getInt(instance);
        }
        catch (Exception e) {
            System.err.println(field.getType() + " not assignable from " + Integer.TYPE);
            return -1;
        }
    }

    public static boolean setField(Field field, Object instance, Object value) {
        if (field == null) {
            System.err.println("Null field");
            return false;
        }
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            System.err.println(field.getType() + " not assignable from " + value.getClass());
            return false;
        }
        return true;
    }

    public static Field getField(String[] fieldNames, Class clazz) {
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        if (fieldNames == null || fieldNames.length < 1) {
            System.err.println("No field name(s) specified.");
            return null;
        }
        Field field = null;
        for (String fieldName : fieldNames) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException nsfe) {
            }
        }
        if (field == null) {
            System.err.println(clazz.getName() + " does not have field " + fieldNames[0]);
            return null;
        }
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return field;
    }

    public static Field getField(String[] fieldNames, Object instance) {
        if (instance != null) {
            return ReflectionHelper.getField(fieldNames, instance.getClass());
        }
        return null;
    }
}

