/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.util;

import com.sijobe.spc.util.Settings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SettingsManager {
    public static final String DEFAULT_EXTENSION = ".properties";
    private Map cache = new HashMap();
    private File root;
    private Settings defaultConfig;

    public SettingsManager(File root) {
        this(root, new Settings());
    }

    public SettingsManager(File root, Settings defaultConfig) {
        if (root == null || !root.exists() || !root.isDirectory()) {
            throw new RuntimeException("Specified settings location does not exist or is not a directory.");
        }
        this.root = root;
        this.defaultConfig = defaultConfig;
    }

    public Settings load(String key) {
        Settings loaded = (Settings)this.cache.get(key);
        if (loaded != null) {
            return loaded;
        }
        File location = new File(this.root, key + DEFAULT_EXTENSION);
        if (location.exists()) {
            loaded = new Settings(location);
        } else {
            loaded = (Settings)this.defaultConfig.clone();
            loaded.setFile(location);
        }
        this.cache.put(key, loaded);
        return loaded;
    }

    public boolean save(String key) {
        Settings save = (Settings)this.cache.get(key);
        if (save == null) {
            return false;
        }
        return save.save();
    }
}

