/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.validation;

import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ValidationException;

public class ParameterDouble
extends Parameter {
    private double min;
    private double max;

    public ParameterDouble(String label, boolean optional) {
        this(label, optional, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ParameterDouble(String label, boolean optional, double min, double max) {
        super(label, optional);
        this.min = min;
        this.max = max;
    }

    @Override
    public Object validate(String parameter) throws ValidationException {
        try {
            double value = Double.parseDouble(parameter);
            if (value > this.min && value < this.max) {
                return value;
            }
            System.out.println("V1" + value + " " + this.min + " " + (value > this.min));
            throw new ValidationException("Parameter " + parameter + " is out of the expected range (" + this.min + "-" + this.max + ")");
        }
        catch (NumberFormatException n) {
            throw new ValidationException("Invalid text (" + parameter + ") where double value was expected.");
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }
}

