/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.validation;

import com.sijobe.spc.validation.Parameter;
import com.sijobe.spc.validation.ValidationException;

public class ParameterInteger
extends Parameter {
    private int min;
    private int max;

    public ParameterInteger(String label, boolean optional) {
        this(label, optional, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public ParameterInteger(String label, boolean optional, int min, int max) {
        super(label, optional);
        this.min = min;
        this.max = max;
    }

    @Override
    public Object validate(String parameter) throws ValidationException {
        try {
            int value = Integer.parseInt(parameter);
            if (value > this.min && value < this.max) {
                return value;
            }
            throw new ValidationException("Parameter " + parameter + " is out of the expected range (" + this.min + "-" + this.max + ")");
        }
        catch (NumberFormatException n) {
            throw new ValidationException("Invalid text (" + parameter + ") where integer value was expected.");
        }
        catch (Exception e) {
            throw new ValidationException();
        }
    }
}

