/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.worldedit;

import com.sijobe.spc.worldedit.MinecraftBiomeType;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Minecraft;
import com.sijobe.spc.wrapper.World;
import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.regions.Region;
import java.util.Locale;

public class LocalWorld
extends com.sk89q.worldedit.LocalWorld {
    private World world;

    public LocalWorld(World world) {
        this.world = world;
    }

    public boolean clearContainerBlockContents(Vector pos) {
        return this.world.emptyContainer(this.getCoordinate(pos));
    }

    public boolean copyFromWorld(Vector pos, BaseBlock type) {
        return false;
    }

    public boolean copyToWorld(Vector pos, BaseBlock type) {
        return false;
    }

    public void dropItem(Vector pos, BaseItemStack item) {
    }

    public boolean equals(Object world) {
        if (world instanceof LocalWorld) {
            return ((LocalWorld)((Object)world)).getName().equals(this.getName());
        }
        return false;
    }

    public BiomeType getBiome(Vector2D arg0) {
        aav biome = this.world.getMinecraftWorld().a(arg0.getBlockX(), arg0.getBlockZ());
        try {
            return MinecraftBiomeType.valueOf(biome.y.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return BiomeType.UNKNOWN;
        }
    }

    public BaseBlock getBlock(Vector pos) {
        try {
            return new BaseBlock(this.getBlockType(pos), this.getBlockData(pos));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isValidBlockType(int type) {
        if (type == 0) {
            return true;
        }
        return this.world.isValidBlockType(type);
    }

    public int getBlockData(Vector pos) {
        return this.world.getBlockData(this.getCoordinate(pos));
    }

    public int getBlockLightLevel(Vector pos) {
        return this.world.getBlockLightLevel(this.getCoordinate(pos));
    }

    public int getBlockType(Vector pos) {
        return this.world.getBlockId(this.getCoordinate(pos));
    }

    public String getName() {
        return this.world.getName();
    }

    public int hashCode() {
        return this.world.getName().hashCode();
    }

    public boolean regenerate(Region arg0, EditSession arg1) {
        return false;
    }

    public int removeEntities(EntityType entity, Vector pos, int area) {
        return 1;
    }

    public void setBiome(Vector2D arg0, BiomeType arg1) {
        if (arg1 instanceof MinecraftBiomeType) {
            int biomeId = ((MinecraftBiomeType)arg1).getBiomeID();
            int x2 = arg0.getBlockX();
            int z = arg0.getBlockZ();
            if (this.world.getMinecraftWorld().f(x2, 0, z)) {
                abw chunk = this.world.getMinecraftWorld().d(x2, z);
                if (chunk != null) {
                    byte[] biomevals = chunk.m();
                    biomevals[(z & 0xF) << 4 | x2 & 0xF] = (byte)biomeId;
                    Minecraft.getMinecraft().g.q.d(x2, z).a(biomevals);
                } else {
                    System.err.println("Can't set biome for null chunk.");
                }
            } else {
                System.err.println("Not setting biome.");
            }
        }
    }

    @Deprecated
    public void setBlockData(Vector pos, int block) {
        this.world.setBlockData(this.getCoordinate(pos), block);
    }

    @Deprecated
    public void setBlockDataFast(Vector pos, int block) {
        this.world.setBlockData(this.getCoordinate(pos), block);
    }

    @Deprecated
    public boolean setBlockType(Vector pos, int block) {
        return this.world.setBlock(this.getCoordinate(pos), block);
    }

    @Deprecated
    public boolean generateBigTree(EditSession session, Vector pos) {
        return this.world.generateBigTree(this.getCoordinate(pos));
    }

    @Deprecated
    public boolean generateTree(EditSession session, Vector pos) {
        return this.world.generateTree(this.getCoordinate(pos));
    }

    @Deprecated
    public boolean generateTallRedwoodTree(EditSession session, Vector pos) {
        return this.world.generateTallRedwoodTree(this.getCoordinate(pos));
    }

    @Deprecated
    public boolean generateRedwoodTree(EditSession session, Vector pos) {
        return this.world.generateRedwoodTree(this.getCoordinate(pos));
    }

    @Deprecated
    public boolean generateBirchTree(EditSession session, Vector pos) {
        return this.world.generateBirchTree(this.getCoordinate(pos));
    }

    @Deprecated
    public int killMobs(Vector pos, int radius) {
        return 1;
    }

    private Coordinate getCoordinate(Vector pos) {
        return new Coordinate(pos.getX(), pos.getY(), pos.getZ());
    }
}

