/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.worldedit;

import com.sijobe.spc.core.PlayerSP;
import com.sijobe.spc.worldedit.WorldEditCommandSet;
import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Minecraft;
import com.sijobe.spc.wrapper.Player;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.input.Mouse;

public class WorldEditEvents
extends PlayerSP {
    private Map left = new HashMap();
    private Map right = new HashMap();
    private String lastCrash = "";
    private int tock = 0;
    private static final int TRACE_RANGE = 128;

    @Override
    public void onTick(Player player) {
        this.tock = this.tock == 100 ? 0 : ++this.tock;
        if (Minecraft.isGuiScreenOpen()) {
            return;
        }
        try {
            this.checkLeftButton(player);
            this.checkRightButton(player);
        }
        catch (Throwable e) {
            String currentCrash = e.toString();
            if (currentCrash.equals(this.lastCrash)) {
                return;
            }
            this.lastCrash = currentCrash;
            e.printStackTrace();
        }
    }

    private void checkLeftButton(Player player) {
        if (Mouse.isButtonDown((int)0)) {
            Coordinate hit = null;
            hit = player.trace(128.0);
            if (hit != null) {
                WorldEditCommandSet.getCurrentInstance().handleArmSwing(player);
                if (!hit.equals(this.left.get(player.getPlayerName()))) {
                    this.left.put(player.getPlayerName(), hit);
                    WorldEditCommandSet.getCurrentInstance().handleBlockLeftClick(player, hit);
                }
            }
        }
    }

    private void checkRightButton(Player player) {
        if (Mouse.isButtonDown((int)1)) {
            Coordinate hit = null;
            hit = player.trace(128.0);
            if (hit != null) {
                WorldEditCommandSet.getCurrentInstance().handleRightClick(player);
                if (!hit.equals(this.right.get(player.getPlayerName()))) {
                    this.right.put(player.getPlayerName(), hit);
                    WorldEditCommandSet.getCurrentInstance().handleBlockRightClick(player, hit);
                }
            }
        }
    }
}

