/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.spc.wrapper;

import com.sijobe.spc.wrapper.Coordinate;
import com.sijobe.spc.wrapper.Item;
import com.sijobe.spc.wrapper.Stats;
import com.sijobe.spc.wrapper.World;

public class Player {
    private final sq player;

    public Player(sq player) {
        this.player = player;
    }

    public void setPosition(Coordinate c) {
        if (this.player instanceof jc) {
            ((jc)this.player).a(c.getX(), c.getY(), c.getZ());
        } else {
            this.player.b(c.getX(), c.getY(), c.getZ());
        }
    }

    public Coordinate getPosition() {
        return new Coordinate(this.player.u, this.player.v, this.player.w);
    }

    public float getYaw() {
        return this.player.A;
    }

    public void setYaw(float yaw) {
        this.player.A = yaw;
    }

    public float getPitch() {
        return this.player.B;
    }

    public void setPitch(float pitch) {
        this.player.B = pitch;
    }

    public World getWorld() {
        if (this.player instanceof jc) {
            return new World(((jc)this.player).c.a);
        }
        return new World(this.player.q);
    }

    public void sendChatMessage(String message) {
        this.player.b(message);
    }

    public void givePlayerItem(int id) {
        this.givePlayerItem(id, Item.getMaxStack(id));
    }

    public void givePlayerItem(int id, int quantity) {
        this.givePlayerItem(id, quantity, 0);
    }

    public void givePlayerItem(int id, int quantity, int damage) {
        wm itemStack = new wm(id, quantity, damage);
        if (!this.player.bK.a(itemStack)) {
            this.player.c(itemStack);
        }
    }

    public int getHealth() {
        return this.player.aX();
    }

    public void setHealth(int health) {
        this.player.b(health);
    }

    public void heal(int quantity) {
        this.setHealth(this.getHealth() + quantity);
    }

    public int getHunger() {
        return this.player.cn().a();
    }

    public void setHunger(int food) {
        this.player.cn().a(food);
    }

    public boolean getDamage() {
        return !this.player.ce.a;
    }

    public void setDamage(boolean damage) {
        this.player.ce.a = !damage;
    }

    public boolean setInventorySlot(int slot, int id, int quantity, int damage) {
        if (slot < 0 || slot >= this.player.bK.a.length) {
            return false;
        }
        if (!Item.isValidItem(id)) {
            if (id == 0) {
                this.player.bK.a[slot] = null;
                return true;
            }
            return false;
        }
        this.player.bK.a[slot] = new wm(id, quantity, damage);
        return true;
    }

    public Coordinate trace(double distance) {
        ara m = this.rayTrace(distance, 1.0f);
        if (m == null) {
            return null;
        }
        return new Coordinate(m.b, m.c, m.d);
    }

    public ara rayTrace(double distance, float partialTickTime) {
        arc positionVec = this.getPositionVec(partialTickTime);
        arc lookVec = this.player.i(partialTickTime);
        arc hitVec = positionVec.c(lookVec.c * distance, lookVec.d * distance, lookVec.e * distance);
        return this.player.q.a(positionVec, hitVec);
    }

    public arc getPositionVec(float partialTickTime) {
        double offsetY = this.player.v + (double)this.player.e();
        if (partialTickTime == 1.0f) {
            return this.getWorld().getMinecraftWorld().U().a(this.player.u, offsetY, this.player.w);
        }
        double var2 = this.player.r + (this.player.u - this.player.r) * (double)partialTickTime;
        double var4 = this.player.s + (offsetY - (this.player.s + (double)this.player.e())) * (double)partialTickTime;
        double var6 = this.player.t + (this.player.w - this.player.t) * (double)partialTickTime;
        return this.getWorld().getMinecraftWorld().U().a(var2, var4, var6);
    }

    public boolean setGameType(String gametype) {
        aaj chosen = null;
        chosen = aaj.a((String)gametype);
        if (chosen == null) {
            return false;
        }
        this.player.a(chosen);
        return true;
    }

    public String getPlayerName() {
        return this.player.bS;
    }

    public int getCurrentItem() {
        try {
            return this.player.bK.a[this.getCurrentSlot()].c;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public int getCurrentSlot() {
        return this.player.bK.c;
    }

    public void setSkin(String URL2) {
        this.player.cv = URL2;
    }

    public void setMotion(Coordinate motion) {
        this.player.x = motion.getX();
        this.player.y = motion.getY();
        this.player.z = motion.getZ();
    }

    public Coordinate getMotion() {
        return new Coordinate(this.player.x, this.player.y, this.player.z);
    }

    public boolean isClear(Coordinate location) {
        return this.getWorld().getBlockId(location.getBlockX(), location.getBlockY(), location.getBlockZ()) == 0 && this.getWorld().getBlockId(location.getBlockX(), location.getBlockY() + 1, location.getBlockZ()) == 0 && this.getWorld().getBlockId(location.getBlockX(), location.getBlockY() - 1, location.getBlockZ()) != 0;
    }

    public float getMovementForward() {
        if (this.player instanceof jc) {
            return ((jc)this.player).getMovementForward();
        }
        if (this.player instanceof bdv) {
            return ((bdv)this.player).getMovementForward();
        }
        return 0.0f;
    }

    public float getMovementStrafe() {
        if (this.player instanceof jc) {
            return ((jc)this.player).getMovementStrafe();
        }
        if (this.player instanceof bdv) {
            return ((bdv)this.player).getMovementStrafe();
        }
        return 0.0f;
    }

    public void setStepHeight(float height) {
        this.player.Y = height;
    }

    public float getStepHeight() {
        return this.player.Y;
    }

    public sq getMinecraftPlayer() {
        return this.player;
    }

    public void removePotionEffect(int potion) {
        this.player.o(potion);
    }

    public void removeAllPotionEffects() {
        this.player.bB();
    }

    public void addPotionEffect(int id, int duration, int strength) {
        this.player.d(new ml(id, duration, strength));
    }

    public void changeDimension(int dimension) {
        this.player.c(dimension);
    }

    public void setAir(int air) {
        this.player.g(air);
    }

    public boolean addAchievement(String name) {
        if (this.player instanceof bdv && Stats.doesAchievementExist(name)) {
            this.player.a((ka)Stats.getAchievementByName(name));
            return true;
        }
        return false;
    }

    public boolean getAllowFlying() {
        return this.player.ce.c;
    }

    public void setAllowFlying(boolean allow) {
        this.player.ce.c = allow;
        this.player.ce.b = allow;
        this.player.n();
    }

    public boolean isCreativeMode() {
        return this.player.ce.d;
    }
}

